TITLE   'Transient Heating of Steel Bar'				{ exa191.pde }
SELECT     						{ Student Edition }
   errlim=1e-3     ngrid=1     spectral_colors
VARIABLES   temp( threshold=0.1)		{ Absolute tolerance }
DEFINITIONS
   L=100e-3     L0=10e-3     heat     k     rcp     tempi=300
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)	
   power_d=1e7						{ Power density }
   power=(2*L0)* (2*L0/3)*power_d			{ Power from bar }	
INITIAL VALUES
   temp=tempi
EQUATIONS
   div( fluxd)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain'  heat=0  k=0.5  rcp=2e6         		{ Glass fiber }
   start (-L,-L)  value( temp)=tempi
   line to (L,-L) to (L,L) to (-L,L)  close
region 'steel'  heat=power_d  k=45  rcp=3.5e6     	{ Stainless steel }
   start (-L0,-L0/3) line to (L0,-L0/3) to (L0,L0/3) to (-L0,L0/3) close
TIME   from 0 to 1e6
PLOTS
   for t=100, 300, 1e3, 3e3, 1e4, 3e4, 1e5, 3e5, 1e6
   contour( temp)     contour( (temp-tempi)*rcp) report( power*t)
   contour( temp) zoom(-5*L0,-5*L0,  10*L0,10*L0)	
END

